local judgeFont = "_francophilsans Bold 24px"
local labelZoom = 18/24

local labelYOffset = {
	TapNoteScore_W1 = -50,
	TapNoteScore_W2 = -34,
	TapNoteScore_W3 = -18,
	TapNoteScore_W4 = -2,
	TapNoteScore_W5 = 14,
	TapNoteScore_Miss = 30,
}

local tnsOffDelay = {
	TapNoteScore_W1		= 0.1,
	TapNoteScore_W2		= 0.15,
	TapNoteScore_W3		= 0.2,
	TapNoteScore_W4		= 0.25,
	TapNoteScore_W5		= 0.2,
	TapNoteScore_Miss	= 0.15,
}

-- todo: player-specific stuff
local function JudgeLabel(pn,tns)
	local tn = ToEnumShortString(tns)
	local flip = pn == PLAYER_1 and -1 or 1
	local textAlign = pn == PLAYER_1 and 1 or 0
	local xPos = pn == PLAYER_1 and -14 or 14
	return LoadFont(judgeFont)..{
		Name="Label"..pname(pn)..tn;
		Text=THEME:GetString("TapNoteScore",tn);
		InitCommand=cmd(x,xPos;y,labelYOffset[tns];halign,textAlign;shadowlength,1;zoom,labelZoom;diffuse,JudgeColors[tn]);
		BeginCommand=function(self)
			if tns == "TapNoteScore_W1" then
				self:diffuse( color("#ffff30") )
				self:diffusetopedge( color("#FFFFFF") )
				self:diffusebottomedge( color("#ffaf00") )
			end
		end;
		OffCommand=cmd(sleep,tnsOffDelay[tns];linear,0.25;addx,SCREEN_WIDTH*flip);
	};
end

local t = Def.ActorFrame{}

for pn in ivalues(PlayerNumber) do
	for k,v in pairs(labelYOffset) do
		table.insert(t,JudgeLabel(pn,k))
	end
	-- todo: add max combo to the festivities
end

return t
